$(function () {

	initialize();

	function initialize() {
		// Use lang attribute <html lang="xx">
		var langCode = $("html").attr("lang");

		setLabels(langCode);
		initMenu();
		$("#menu_tab").attr("checked", "checked");

	}

	// Set labels to HTML
	function setLabels(langCode) {

		// Title / Meta
		var titleText = $("title").html();
		if (langCode == "ar-GC") {
			titleText = "&rlm;" + titleText + "&lrm;| " + getResourceString(langCode, "modelCode") + " &rlm;" + getResourceString(langCode, "title") + "&lrm; | &rlm;" + getResourceString(langCode, "CompanyName");
		} else {
			titleText += " | " + getResourceString(langCode, "title") + " " + getResourceString(langCode, "modelCode") + " | " + getResourceString(langCode, "CompanyName");
		}
		$("title").html(titleText);
		$("#meta_copyright").attr("content", getResourceString(langCode, "copyright"));

		// Header / Body
		$("#link_index").html(getResourceString(langCode, "title"));
		$("#model_code").html(getResourceString(langCode, "modelCode"));
		$("#btn_print > a").html(getResourceString(langCode, "printLabel"));
		$("#goto_menu > a").html(getResourceString(langCode, "mobileMenu"));
		$("#goto_top > a").html(getResourceString(langCode, "gotoTop"));
		var breadcrumbTop = $("#breadcrumb_top > a");
		if (breadcrumbTop.length != 0) {
			breadcrumbTop.html(getResourceString(langCode, "top"));
		}
		$("#menu_tab").next().html(getResourceString(langCode, "tabToc"));
		$("#menu_tab").next().html(getResourceString(langCode, "tabToc"));
		$("#search_tab").next().html(getResourceString(langCode, "tabSearch"));
		$("#btn_search > a").html(getResourceString(langCode, "buttonSearch"));
		$("#search .search_results_label .label").html(getResourceString(langCode, "searchResultLabel"));
		$("#search .search_results_label .result_count .unit").html(getResourceString(langCode, "searchItemCountUnit"));
		$("#keyword").attr("placeholder", getResourceString(langCode, "searchPlaceholder"));

		// Footer
		$("#about > a").html(getResourceString(langCode, "about"));
		$("#revision_date").html(getResourceString(langCode, "revisionDate"));
		$("#copyright").html(getResourceString(langCode, "copyright"));
		$("#manufacturing_code").html(getResourceString(langCode, "manufacturingCode"));
		$("#parts_code").html(getResourceString(langCode, "partsCode"));

	}

	function getResourceString(langCode, key) {
		var resource = resources[langCode][key];
		// console.log(resource)
		return resource;
	}

	function initMenu() {
		// Load toc object.
		var tocObject = toc;

		// create menu structure.
		var menuTags = createMenuTags(tocObject);

		// insert tags for PC
		$("#menu").html(menuTags.clone());

		// insert tags for Mobile
		// (same as PC)
		$("#menu_mob").html(menuTags.clone());
	}

	// Create menu structure.
	function createMenuTags(tocObject) {

		// ClassName Definitions
		var level0Class = "item_chapter";
		var level1Class = "item_lv1";
		var level2Class = "item_lv2";

		var menuTags = $("<ul>").addClass("toc");

		// roop for Chapter
		$.each(tocObject, function (index, chapter) {

			// Chapter
			// console.log(chapter.label);
			var chapterTag = createMenuItem(level0Class, chapter.link, chapter.label)

			if (chapter.subMenu.length > 0) {

				var level1WrapperTag = $("<ul>").addClass("menu_lv1");
				// roop for level1 submenu
				$.each(chapter.subMenu, function (index, level1SubMenu) {

					// Level 1 submenu
					// console.log("level1:"+ level1SubMenu.label);
					var level1SubMenuTag = createMenuItem(level1Class, level1SubMenu.link, level1SubMenu.label);
					level1SubMenuTag.appendTo(level1WrapperTag);
				});

				level1WrapperTag.appendTo(chapterTag);
			}

			chapterTag.appendTo(menuTags);

		});

		return menuTags;
	}

	// Create <li> tag structure.
	// <li><div class="#className#"><a href="#fileName#">#labelName#</a></div>
	// 
	// (exsample)
	// <li><div class="item_chapter"><a href="chapter01.htm">はじめに</a></div>
	function createMenuItem(className, fileName, labelName) {
		var menuItem = $("<li>");
		var menuItemElement = $("<div>").addClass(className);
		var atag = $("<a>").attr("href", fileName).html(labelName);
		atag.appendTo(menuItemElement);
		menuItemElement.appendTo(menuItem);

		return menuItem;
	}

});

(function ($) {
	var props = ['Width', 'Height'], prop;

	while (prop = props.pop()) {
		(function (natural, prop) {
			$.fn[natural] = (natural in new Image()) ?
				function () {
					return this[0][natural];
				} :
				function () {
					var node = this[0], img, value;

					if (node.tagName.toLowerCase() === 'img') {
						img = new Image();
						img.src = node.src,
							value = img[prop];
					}
					return value;
				};
		}('natural' + prop, prop.toLowerCase()));
	}
}(jQuery));


$(window).on('load', function () {
	$("p img").each(function () {
		var width = $(this).naturalWidth();
		$(this).width(width / 2.0);
		console.log($(this).width(width / 2.0));
		$(this).css("visibility", "visible");
	});
});